for file in aqmon_queue_*.11.2.persistent.gnuplot    # plot for 11.2 persistent queues
do 
  if ls $file; then
    tmpplot="_$file.gnu"

    echo "set terminal png" >> $tmpplot
    echo "set output '"$file".png'" >> $tmpplot
    echo "set multiplot" >> $tmpplot
   
    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.0,0.7" >> $tmpplot
    echo "plot '"$file"' using 1:2 title 'ENQUEUED_MSGS' with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:3 title 'DEQUEUED_MSGS' with linespoints pointtype 2,\\" >> $tmpplot
    echo "     '"$file"' using 1:4 title 'BROWSED_MSGS'  with linespoints pointtype 3   " >> $tmpplot


    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.5,0.7" >> $tmpplot
    echo "plot '"$file"' using 1:5 title 'ENQUEUED_EXPIRY_MSGS' with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:6 title 'ENQUEUED_DELAY_MSGS'  with linespoints pointtype 2,\\" >> $tmpplot
    echo "     '"$file"' using 1:7 title 'MSGS_MADE_EXPIRED'    with linespoints pointtype 3,\\" >> $tmpplot
    echo "     '"$file"' using 1:8 title 'MSGS_MADE_READY'      with linespoints pointtype 4   " >> $tmpplot

    
    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.0,0.35" >> $tmpplot
    echo "plot '"$file"' using 1:9  title 'ENQUEUE_RATE(msg/s)' with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:10 title 'DEQUEUE_RATE(msg/s)' with linespoints pointtype 2   " >> $tmpplot

    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.5,0.35" >> $tmpplot
    echo "plot '"$file"' using 1:11 title 'AVG_TIME_PER_ENQUEUE(us)' with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:12 title 'AVG_TIME_PER_DEQUEUE(us)' with linespoints pointtype 2,\\" >> $tmpplot
    echo "     '"$file"' using 1:13 title 'CPU_TIME_PER_ENQUEUE(us)' with linespoints pointtype 3,\\" >> $tmpplot
    echo "     '"$file"' using 1:14 title 'CPU_TIME_PER_DEQUEUE(us)' with linespoints pointtype 4   " >> $tmpplot

    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.0,0.0" >> $tmpplot
    echo "plot '"$file"' using 1:18 title 'TRANSFORMATION_TIME(us)' with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:19 title 'RULE_EVAL_TIME(us)'      with linespoints pointtype 2   " >> $tmpplot

    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.5,0.0" >> $tmpplot
    echo "plot '"$file"' using 1:20 title 'PENDING_MSGS(ACCUM)' with linespoints pointtype 1" >> $tmpplot

    echo "unset multiplot" >> $tmpplot

    gnuplot $tmpplot

    rm $tmpplot

  fi
done

#######################################################

for file in aqmon_queue_*.11.2.buffered.gnuplot   # plot for 11.2 buffered queues
do 
  if ls $file; then
    tmpplot="_$file.gnu"

    echo "set terminal png" >> $tmpplot
    echo "set output '"$file".png'" >> $tmpplot
    echo "set multiplot" >> $tmpplot
   
    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.0,0.7" >> $tmpplot
    echo "plot '"$file"' using 1:2 title 'ENQUEUED_MSGS' with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:3 title 'DEQUEUED_MSGS' with linespoints pointtype 2,\\" >> $tmpplot
    echo "     '"$file"' using 1:4 title 'SPILLED_MSGS'  with linespoints pointtype 3,\\" >> $tmpplot
    echo "     '"$file"' using 1:5 title 'EXPIRED_MSGS'  with linespoints pointtype 4   " >> $tmpplot

    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.5,0.7" >> $tmpplot
    echo "plot '"$file"' using 1:6 title 'ENQUEUE_RATE(msg/s)' with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:7 title 'DEQUEUE_RATE(msg/s)' with linespoints pointtype 2   " >> $tmpplot
    
    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.0,0.35" >> $tmpplot
    echo "plot '"$file"' using 1:8  title 'AVG_TIME_PER_ENQUEUE(us)' with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:9  title 'AVG_TIME_PER_DEQUEUE(us)' with linespoints pointtype 2,\\" >> $tmpplot
    echo "     '"$file"' using 1:10 title 'CPU_TIME_PER_ENQUEUE(us)' with linespoints pointtype 3,\\" >> $tmpplot
    echo "     '"$file"' using 1:11 title 'CPU_TIME_PER_DEQUEUE(us)' with linespoints pointtype 4   " >> $tmpplot


    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.5,0.35" >> $tmpplot
    echo "plot '"$file"' using 1:12 title 'TRANSFORMATION_TIME(us)' with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:13 title 'RULE_EVAL_TIME(us)'      with linespoints pointtype 2   " >> $tmpplot

    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.0,0.0" >> $tmpplot
    echo "plot '"$file"' using 1:14 title 'PENDING_MSGS(ACCUM)' with linespoints pointtype 1" >> $tmpplot

    #echo "set size 0.5,0.3" >> $tmpplot
    #echo "set origin 0.5,0.0" >> $tmpplot

    echo "unset multiplot" >> $tmpplot

    gnuplot $tmpplot

    rm $tmpplot
  fi
done


#######################################################

for file in aqmon_queue_*.11.1.persistent.gnuplot    # plot for 11.1 persistent queues
do 
  if ls $file; then
    tmpplot="_$file.gnu"

    echo "set terminal png" >> $tmpplot
    echo "set output '"$file".png'" >> $tmpplot
    echo "set multiplot" >> $tmpplot
   
    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.0,0.7" >> $tmpplot
    echo "plot '"$file"' using 1:2 title 'ENQUEUED_MSGS' with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:3 title 'DEQUEUED_MSGS' with linespoints pointtype 2,\\" >> $tmpplot
    echo "     '"$file"' using 1:4 title 'BROWSED_MSGS'  with linespoints pointtype 3   " >> $tmpplot


    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.5,0.7" >> $tmpplot
    echo "plot '"$file"' using 1:5 title 'ENQUEUED_EXPIRY_MSGS' with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:6 title 'ENQUEUED_DELAY_MSGS'  with linespoints pointtype 2,\\" >> $tmpplot
    echo "     '"$file"' using 1:7 title 'MSGS_MADE_EXPIRED'    with linespoints pointtype 3,\\" >> $tmpplot
    echo "     '"$file"' using 1:8 title 'MSGS_MADE_READY'      with linespoints pointtype 4   " >> $tmpplot

    
    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.0,0.35" >> $tmpplot
    echo "plot '"$file"' using 1:9  title 'ENQUEUE_RATE(msg/s)' with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:10 title 'DEQUEUE_RATE(msg/s)' with linespoints pointtype 2   " >> $tmpplot

    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.5,0.35" >> $tmpplot
    echo "plot '"$file"' using 1:11 title 'AVG_TIME_PER_ENQUEUE(us)'     with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:12 title 'AVG_TIME_PER_DEQUEUE(us)'     with linespoints pointtype 2  " >> $tmpplot

    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.0,0.0" >> $tmpplot
    echo "plot '"$file"' using 1:18 title 'TRANSFORMATION_TIME(us)' with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:19 title 'RULE_EVAL_TIME(us)'      with linespoints pointtype 2   " >> $tmpplot

    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.5,0.0" >> $tmpplot
    echo "plot '"$file"' using 1:20 title 'PENDING_MSGS(ACCUM)' with linespoints pointtype 1" >> $tmpplot

    echo "unset multiplot" >> $tmpplot

    gnuplot $tmpplot

    rm $tmpplot

  fi;
done

#######################################################

for file in aqmon_queue_*.11.1.buffered.gnuplot   # plot for 11.1 buffered queues
do 
  if ls $file; then
    tmpplot="_$file.gnu"

    echo "set terminal png" >> $tmpplot
    echo "set output '"$file".png'" >> $tmpplot
    echo "set multiplot" >> $tmpplot
   
    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.0,0.7" >> $tmpplot
    echo "plot '"$file"' using 1:2 title 'ENQUEUED_MSGS' with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:3 title 'DEQUEUED_MSGS' with linespoints pointtype 2,\\" >> $tmpplot
    echo "     '"$file"' using 1:4 title 'SPILLED_MSGS'  with linespoints pointtype 3,\\" >> $tmpplot
    echo "     '"$file"' using 1:5 title 'EXPIRED_MSGS'  with linespoints pointtype 4   " >> $tmpplot

    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.5,0.7" >> $tmpplot
    echo "plot '"$file"' using 1:6 title 'ENQUEUE_RATE(msg/s)' with linespoints pointtype 1,\\" >> $tmpplot
    echo "     '"$file"' using 1:7 title 'DEQUEUE_RATE(msg/s)' with linespoints pointtype 2   " >> $tmpplot
    
    echo "set size 0.5,0.3" >> $tmpplot
    echo "set origin 0.0,0.35" >> $tmpplot
    echo "plot '"$file"' using 1:14 title 'PENDING_MSGS(ACCUM)' with linespoints pointtype 1" >> $tmpplot

    echo "unset multiplot" >> $tmpplot

    gnuplot $tmpplot

    rm $tmpplot
  fi
done

# $Header: rdbms/demo/aqmonitor.plot /main/1 2009/11/11 13:40:22 xingjin Exp $
#
# aqmonitor.plot
#
# Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#     aqmonitor.plot - plotting script with AQ monitor
#
#   DESCRIPTION
#     plot figures based on monitoring reports.
#     See Section 2.2.3 in aqmonitorREADME.txt for how to use this script
#
#   NOTES
#
#   MODIFIED   (MM/DD/YY)
#   xingjin     11/05/09 - Creation
#
